# Small nix-shell environment for python 3.10 + poetry
#
# See https://nixos.wiki/wiki/Python
# launch with nix-shell (and not 'nix shell' !)
#
# nix-shell --run 'python --version; poetry --version'
# Python 3.10.13
# Poetry (version 1.7.1)
#
# Also, you can heck https://nixos.org/manual/nixpkgs/stable/#sec-pkgs-mkShell
#
let
  pkgs = import <nixpkgs> { };
  pythonEnv = pkgs.python310.withPackages (pythonPackages: with pythonPackages; [
    jinja2
    pyyaml
    pip
    numpy
    psycopg
    virtualenv
  ]);
  packages = with pkgs; [
    postgresql_14
    pythonEnv
    stdenv.cc.cc.lib
  ];
in
pkgs.mkShell {
  packages = packages;
  shellHook = ''
    export LD_LIBRARY_PATH="${pkgs.postgresql_14.lib}/lib:${pkgs.stdenv.cc.cc.lib}/lib:$LD_LIBRARY_PATH"
    python --version
    poetry --version

    export VIRTUAL_ENV_DISABLE_PROMPT=1
    export POETRY_VENV=/tmp/.venv-py310-poetry

    if test ! -e $POETRY_VENV
    then
      python -m venv $POETRY_VENV
      $POETRY_VENV/bin/pip install poetry
    fi

    alias ll='ls -ltr'
    alias poetry=$POETRY_VENV/bin/poetry
  '';
}
