# Small nix-shell environment for python 3.10 + poetry
#
# See https://nixos.wiki/wiki/Python
# launch with nix-shell (and not 'nix shell' !)
#
# nix-shell --run 'python --version; poetry --version'
# Python 3.10.13
# Poetry (version 1.7.1)
#
# Also, you can heck https://nixos.org/manual/nixpkgs/stable/#sec-pkgs-mkShell
#
let
  pkgs = import <nixpkgs> { };
in
pkgs.mkShell {
  packages = with pkgs; [
    (python310.withPackages (python-pkgs: with python-pkgs; [
      pip
      # poetry-core
      numpy
      psycopg
      virtualenv
    ]))
    postgresql_14
    stdenv.cc.cc.lib
  ];
  shellHook = ''
    export LD_LIBRARY_PATH="${pkgs.postgresql_14.lib}/lib:${pkgs.stdenv.cc.cc.lib}/lib:$LD_LIBRARY_PATH"
    python --version
    if test ! -d /tmp/.venv; then
      python -m venv /tmp/.venv
    fi

    export VIRTUAL_ENV_DISABLE_PROMPT=1
    source /tmp/.venv/bin/activate

    if test ! -e /tmp/.venv/bin/poetry; then
      pip install poetry
    fi
  '';
}